<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

function rp_default_break_minutes($start, $end){
  $mins = max(0, intval((strtotime($end) - strtotime($start)) / 60));
  if ($mins < 360) return 0;
  if ($mins <= 480) return 30;
  return 45;
}

$in = rp_json_input();
$name      = trim((string)($in['name'] ?? ''));
$startDate = $in['start_date'] ?? '';
$endDate   = $in['end_date'] ?? '';
$shifts    = is_array($in['shifts'] ?? null) ? $in['shifts'] : [];
$status    = in_array(($in['status'] ?? 'draft'), ['draft','published'], true) ? $in['status'] : 'draft';
$rosterId  = (int)($in['roster_id'] ?? 0);

if ($name === '') rp_json(['ok'=>false,'error'=>'Naam is verplicht'], 422);
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/',$startDate) || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$endDate)) rp_json(['ok'=>false,'error'=>'Ongeldige datums (YYYY-MM-DD)'], 422);
if (strtotime($endDate) < strtotime($startDate)) rp_json(['ok'=>false,'error'=>'Einddatum < startdatum'], 422);
if (empty($shifts)) rp_json(['ok'=>false,'error'=>'Voeg minimaal één dienst toe'], 422);

/* === dezelfde validaties als validate.php, incl. "multi" === */
$uids = [];
foreach ($shifts as $s) foreach (($s['user_ids'] ?? []) as $uid) $uids[(int)$uid]=true;
$names = [];
if ($uids){
  $ph = implode(',', array_fill(0, count($uids), '?'));
  $stm = $pdo->prepare("SELECT id, COALESCE(full_name,email) name FROM users WHERE id IN ($ph)");
  $stm->execute(array_keys($uids));
  foreach ($stm->fetchAll() as $r) $names[(int)$r['id']] = $r['name'];
}
$deptIds = [];
foreach ($shifts as $s) $deptIds[(int)$s['department_id']]=true;
$bh=[];
if ($deptIds){
  $ph = implode(',', array_fill(0, count($deptIds), '?'));
  $stm = $pdo->prepare("SELECT department_id, weekday, is_closed, open_time, close_time FROM business_hours WHERE department_id IN ($ph)");
  $stm->execute(array_keys($deptIds));
  foreach ($stm->fetchAll() as $r){
    $d=(int)$r['department_id']; $w=(int)$r['weekday'];
    $bh[$d][$w] = ['open'=>$r['open_time']?:'09:00:00','close'=>$r['close_time']?:'18:00:00','closed'=>(int)$r['is_closed']===1];
  }
}
$conflicts=[];
$byUserDay=[];
foreach ($shifts as $s){
  $date = substr($s['start_at'],0,10);
  $a = strtotime($s['start_at']); $b = strtotime($s['end_at']);
  foreach (($s['user_ids'] ?? []) as $uid){
    $byUserDay[$uid][$date] = $byUserDay[$uid][$date] ?? [];
    $byUserDay[$uid][$date][] = [$a,$b];
  }
}
foreach ($byUserDay as $uid=>$days){
  foreach ($days as $date=>$arr){
    usort($arr, fn($x,$y)=>$x[0]<=>$y[0]);
    if (count($arr) > 1) $conflicts[] = ['type'=>'multi','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Meerdere diensten op dezelfde dag'];
    for ($i=1;$i<count($arr);$i++){ [$pa,$pb] = $arr[$i-1]; [$a,$b] = $arr[$i]; if ($a < $pb) $conflicts[] = ['type'=>'overlap','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Overlap binnen zending']; }
  }
}
if (!empty($uids)){
  $startMin = min(array_map(fn($s)=>$s['start_at'],$shifts));
  $endMax   = max(array_map(fn($s)=>$s['end_at'],  $shifts));
  $phU = implode(',', array_fill(0, count($uids), '?'));
  $params = array_merge([$endMax, $startMin], array_keys($uids));
  $sql = "SELECT sa.user_id, s.start_at, s.end_at, DATE(s.start_at) d
          FROM shifts s JOIN shift_assignments sa ON sa.shift_id=s.id
          WHERE s.start_at <= ? AND s.end_at >= ? AND sa.user_id IN ($phU)";
  if ($rosterId>0) $sql .= " AND s.roster_id <> ".((int)$rosterId);
  $stm = $pdo->prepare($sql); $stm->execute($params);
  $existing=[];
  foreach ($stm->fetchAll() as $r) $existing[(int)$r['user_id']][]=[strtotime($r['start_at']),strtotime($r['end_at']),$r['d']];
  foreach ($shifts as $s){
    $a=strtotime($s['start_at']); $b=strtotime($s['end_at']); $date=substr($s['start_at'],0,10);
    foreach (($s['user_ids'] ?? []) as $uid){
      if (array_filter(($existing[$uid] ?? []), fn($x)=>$x[2]===$date)) $conflicts[]=['type'=>'multi','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Deze medewerker heeft al een dienst (DB) op deze dag'];
      foreach (($existing[$uid] ?? []) as [$x,$y]) if ($a<$y && $b>$x) $conflicts[]=['type'=>'overlap','user_id'=>(int)$uid,'user_name'=>$names[(int)$uid] ?? ('#'.$uid),'date'=>$date,'details'=>'Overlap met bestaande dienst'];
    }
  }
}
foreach ($shifts as $s){
  $w=(int)date('N', strtotime($s['start_at'])); $dept=(int)$s['department_id']; $date=substr($s['start_at'],0,10);
  $row=$bh[$dept][$w]??null; if(!$row) continue; $open=$row['open']; $close=$row['close']; $closed=$row['closed'];
  $a=strtotime($s['start_at']); $b=strtotime($s['end_at']); $oa=strtotime("$date $open"); $ob=strtotime("$date $close");
  if ($closed || $a<$oa || $b>$ob) $conflicts[]=['type'=>'business_hours','date'=>$date,'details'=>"Buiten openingstijden ($open–$close) of gesloten"];
}
if ($conflicts) rp_json(['ok'=>false,'error'=>'Conflicten gevonden','conflicts'=>$conflicts], 409);

/* === opslaan === */
try{
  $pdo->beginTransaction();

  if ($rosterId > 0) {
    $pdo->prepare('UPDATE rosters SET name=?, start_date=?, end_date=?, status=?, updated_at=NOW() WHERE id=?')
        ->execute([$name, $startDate, $endDate, $status, $rosterId]);
    $pdo->prepare('DELETE FROM shifts WHERE roster_id=?')->execute([$rosterId]);
  } else {
    $pdo->prepare('INSERT INTO rosters (name, start_date, end_date, status, created_by) VALUES (?,?,?,?,?)')
        ->execute([$name, $startDate, $endDate, $status, $_SESSION['user']['id'] ?? null]);
    $rosterId = (int)$pdo->lastInsertId();
  }

  $insS = $pdo->prepare('INSERT INTO shifts (roster_id, department_id, title, notes, start_at, end_at, break_minutes, created_by) VALUES (?,?,?,?,?,?,?,?)');
  $insA = $pdo->prepare('INSERT INTO shift_assignments (shift_id, user_id) VALUES (?,?)');

  foreach ($shifts as $s) {
    $deptId = (int)($s['department_id'] ?? 0);
    $title  = trim((string)($s['title'] ?? ''));
    $start  = $s['start_at'] ?? '';
    $end    = $s['end_at'] ?? '';
    $uids   = is_array($s['user_ids'] ?? null) ? array_values(array_unique(array_map('intval',$s['user_ids']))) : [];
    $break  = isset($s['break_minutes']) ? max(0, (int)$s['break_minutes']) : rp_default_break_minutes($start,$end);

    if ($deptId <= 0) throw new Exception('Afdeling ontbreekt');
    if (!preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/',$start) || !preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/',$end)) throw new Exception('Ongeldige datum/tijd');
    if (strtotime($end) <= strtotime($start)) throw new Exception('Eindtijd ≤ starttijd');
    if (empty($uids)) throw new Exception('Geen medewerker gekoppeld');

    $insS->execute([$rosterId, $deptId, ($title ?: null), null, $start, $end, $break, $_SESSION['user']['id'] ?? null]);
    $shiftId = (int)$pdo->lastInsertId();
    foreach ($uids as $uid) $insA->execute([$shiftId, $uid]);
  }

  $pdo->commit();
  rp_json(['ok'=>true,'roster_id'=>$rosterId,'name'=>$name,'start_date'=>$startDate,'end_date'=>$endDate,'status'=>$status]);
} catch (Exception $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  rp_json(['ok'=>false,'error'=>$e->getMessage()], 400);
}
