<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

$in = rp_json_input();
$deptIds = is_array($in['department_ids'] ?? null) ? array_map('intval', $in['department_ids']) : [];

if (empty($deptIds)) {
  // alle actieve users
  $q = $pdo->query("SELECT id, email, COALESCE(full_name, email) AS name, role
                    FROM users WHERE is_active=1 ORDER BY name");
  rp_json(['ok'=>true, 'items'=>$q->fetchAll()]);
}

// filter op afdelingen
$ph = implode(',', array_fill(0, count($deptIds), '?'));
$sql = "SELECT DISTINCT u.id, u.email, COALESCE(u.full_name, u.email) AS name, u.role
        FROM users u
        JOIN user_departments ud ON ud.user_id = u.id
        WHERE u.is_active=1 AND ud.department_id IN ($ph)
        ORDER BY name";
$stm = $pdo->prepare($sql);
$stm->execute($deptIds);
rp_json(['ok'=>true, 'items'=>$stm->fetchAll()]);
