'use strict';

(async function(){
  const $ = (q)=>document.querySelector(q);

  // Elements — profiel
  const pForm = $('#profileForm');
  const email = $('#email');
  const phone = $('#phone');
  const first = $('#first');
  const last  = $('#last');
  const list  = $('#deptList');
  const note  = $('#note');
  const deptHelp = $('#deptHelp');

  // Elements — password
  const pwdForm = $('#pwdForm');
  const currentPwd = $('#currentPwd');
  const newPwd = $('#newPwd');
  const newPwd2 = $('#newPwd2');
  const pwdNote = $('#pwdNote');

  const showNote = (el, msg, ok=false) => {
    el.hidden = false;
    el.textContent = msg;
    el.style.background = ok ? '#ecfdf5' : '#eef2ff';
    el.style.borderColor = ok ? '#a7f3d0' : '#c7d2fe';
  };

  // ==== Load profile
  let currentDeptIds = [];
  try {
    const meRes = await fetch('/api/user/me.php');
    const me = await meRes.json();
    if (!meRes.ok || !me.ok) throw new Error(me?.error || 'Kon profiel niet laden');
    email.value = me.user.email;
    first.value = me.user.first_name || '';
    last.value  = me.user.last_name || '';
    phone.value = me.user.phone || '';
    currentDeptIds = me.user.department_ids || [];
  } catch (e) { showNote(note, e.message || 'Kon profiel niet laden'); }

  // Load departments
  try {
    const dRes = await fetch('/api/departments/list.php');
    const d = await dRes.json();
    if (d.ok && d.items.length) {
      list.innerHTML = '';
      d.items.forEach(item => {
        const id = `dept_${item.id}`;
        const wrap = document.createElement('label');
        wrap.className = 'check';
        const checked = currentDeptIds.includes(Number(item.id)) ? 'checked' : '';
        wrap.innerHTML = `
          <input type="checkbox" value="${item.id}" id="${id}" ${checked}>
          <span>${item.name}</span>
        `;
        list.appendChild(wrap);
      });
      deptHelp.textContent = 'Kies minimaal één afdeling.';
    } else {
      deptHelp.textContent = 'Nog geen afdelingen beschikbaar.';
    }
  } catch(_) { deptHelp.textContent = 'Kon afdelingen niet laden.'; }

  // ==== Save profile
  pForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    note.hidden = true;

    const firstVal = first.value.trim();
    const lastVal  = last.value.trim();
    const phoneVal = phone.value.trim();
    const checked  = Array.from(list.querySelectorAll('input[type="checkbox"]:checked')).map(i=>parseInt(i.value,10));

    if (!firstVal || !lastVal || checked.length < 1) {
      return showNote(note, 'Vul voornaam, achternaam in en kies minimaal één afdeling.');
    }

    try {
      const res = await fetch('/api/user/update-profile.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ first_name:firstVal, last_name:lastVal, department_ids:checked, phone:phoneVal })
      });
      const data = await res.json();
      if (!res.ok || data.ok === false) throw new Error(data?.error || 'Opslaan mislukt');
      showNote(note, 'Profiel opgeslagen!', true);
    } catch (err) {
      showNote(note, err.message || 'Opslaan mislukt');
    }
  });

  // ==== Change password
  pwdForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    pwdNote.hidden = true;

    const cur = currentPwd.value;
    const n1  = newPwd.value;
    const n2  = newPwd2.value;

    if (!cur || n1.length < 8) return showNote(pwdNote,'Nieuw wachtwoord moet minimaal 8 tekens zijn.');
    if (n1 !== n2) return showNote(pwdNote,'Nieuw wachtwoord komt niet overeen.');

    try {
      const res = await fetch('/api/user/change-password.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ current_password: cur, new_password: n1 })
      });
      const data = await res.json();
      if (!res.ok || data.ok === false) throw new Error(data?.error || 'Wijzigen mislukt');

      showNote(pwdNote,'Wachtwoord gewijzigd!', true);
      currentPwd.value = newPwd.value = newPwd2.value = '';
    } catch (err) {
      showNote(pwdNote, err.message || 'Wijzigen mislukt');
    }
  });
})();
